#!/usr/bin/env bash
set -e
. /usr/lib/qloud-mail-common.sh

if [ -z "$ENVIRONMENT_TYPE" ]; then
  ENVIRONMENT_TYPE=$DEPLOY_STAGE_ID
fi

if [ -z "$APPLICATION_NAME" ]; then
  APPLICATION_NAME=$DEPLOY_UNIT_ID
fi

if [ -z "$ENVIRONMENT_TYPE" ]; then
  echo 'ENVIRONMENT_TYPE is not set'
  exit 1
fi

if [ -z "$APPLICATION_NAME" ]; then
  echo 'APPLICATION_NAME is not set'
  exit 1
fi

export ENVIRONMENT_TYPE  # Used by application itself

check_ephemeral && qloud_log nginx

if [ -z "$DEPLOY_STAGE_ID" ]; then  # implies this is not Qloud
    ln -sf /etc/nginx/server-ssl.conf /etc/nginx/server-ssl-pointer.conf
fi

ln -sf /etc/nginx/sites-available/unistat.conf /etc/nginx/sites-enabled/unistat.conf
ln -sf /etc/nginx/sites-available/app/testing.conf /etc/nginx/sites-available/app/payments-sdk-backend-testing.conf
ln -sf /etc/nginx/sites-available/app/testing-mimino.conf /etc/nginx/sites-available/app/payments-sdk-backend-testing-mimino.conf
ln -sf /etc/nginx/sites-available/app/production.conf /etc/nginx/sites-available/app/payments-sdk-backend-production.conf
ln -sf /etc/nginx/sites-available/app/$ENVIRONMENT_TYPE.conf /etc/nginx/sites-enabled/app-$ENVIRONMENT_TYPE.conf

ln -sf /etc/supervisor/conf-available/nginx.conf /etc/supervisor/conf.d/nginx.conf
ln -sf /etc/supervisor/conf-available/app/$APPLICATION_NAME.conf /etc/supervisor/conf.d/$APPLICATION_NAME.conf

mkdir -p /var/run/juggler-client/
chown monitor /var/run/juggler-client/

exec "$@"
