#!/usr/bin/env bash

self_tvm_id=2018139

if [ -n "$self_tvm_id" ]
then
    export QLOUD_TVM_SECRET=$(cat ./.tvm.key)
    [[ -f ./.tvm.port ]] || echo $(( (RANDOM % 100) + 33300 )) > ./.tvm.port
    export QLOUD_TVM_PORT=$(cat ./.tvm.port)
    export QLOUD_TVM_INTERFACE_ORIGIN="http://localhost:$QLOUD_TVM_PORT"
    export QLOUD_TVM_TOKEN=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
    export QLOUD_TVM_CONFIG=$(
        jq -n --arg secret "$QLOUD_TVM_SECRET" --argjson self_tvm_id "$self_tvm_id" '{
            "BbEnvType": 0,
            "clients": {
                "payment-sdk-backend": {
                    "secret": $secret,
                    "self_tvm_id": $self_tvm_id,
                    "dsts": {
                        "blackbox": {
                            "dst_id": 224
                        },
                        "trust": {
                            "dst_id": 2001798
                        },
                        "payments": {
                            "dst_id": 2002162
                        },
                        "gozora": {
                            "dst_id": 2023123
                        }
                    }
                }
            }
        }'
    )
    echo $QLOUD_TVM_CONFIG > .tvm.json
    # clean up prev. tvmtool run
    pkill -f "tvmtool.*$QLOUD_TVM_PORT" || true

    export LOG_LOGGER=console
    export LOG_LEVEL=DEBUG
    export CONFIG_PATH=./package/etc/payments-sdk-backend/development.yaml
    export FOLDER_STATIC_NSPK=./package/etc/static/nspk/

    tvmtool --dangerous-bind-all-interfaces --port $QLOUD_TVM_PORT -a $QLOUD_TVM_TOKEN -c .tvm.json > /dev/null &
fi

while [ "$1" != "" ]; do
    case $1 in
        -w  )
            shift
            exec watchmedo auto-restart -R -p "*.go;*.conf;*ya.make" -- "$@"
                                ;;
        * )
            exec "$@"
    esac
    shift
done

