import argparse
import json
from datetime import datetime
from random import seed
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
import requests

acquirers_map = {
    'tinkoff': 'da4ad816-d160-4f47-bc08-af4b0d76756c',
    'kassa': '15ef6295-4eeb-4f13-8c24-b725bac3d73b'
}

merchants_map = {
    'tinkoff': 'messenger_4e7abffd245bf1a7cae68fb4fd5b5ce4',
    'kassa': 'oplata_yakassa_fb3f6eb3270157b3135c4cd19a635553'
}


def handle_anon_basket(service_token, product_id, should_force_3ds):
    test_trust_url = "https://trust-payments-test.paysys.yandex.net:8028/trust-payments/v2/payments"
    seed(datetime.utcnow())
    data = {
        "amount": "100.0",
        "currency": "RUB",
        "product_id": product_id,
        "return_path": "https://yandex.ru/",
        "fiscal_nds": "nds_18",
        "fiscal_title": "PROD TITLE",
        "user_email": "payment-sdk-usr1@yandex.ru",
        "user_phone": "89998887766",
        "payment_mode": 'api_payment'
    }
    if should_force_3ds:
        data["wait_for_cvn"] = 1
        data["pass_params"] = {
            "terminal_route_data": {
                "service_force_3ds": 1
            }
        }
    purchase_token_resp = requests.post(test_trust_url, json=data, headers={
        'X-Service-Token': service_token
    }, verify=False)
    if int(purchase_token_resp.status_code / 100) == 2:
        puch_token_map = json.loads(purchase_token_resp.content)
        print('private val paymentToken = PaymentToken("{}")'.format(puch_token_map['purchase_token']))
        print('private val payer = Payer(null, null, null)')
        print('private val merchant = Merchant("yandex_games_b9b09e9dcc29ef3063e10482b942aa59")')
    else:
        print('error occurred during basket creation, status {}, content: {}'.format(purchase_token_resp.status_code,
                                                                                     purchase_token_resp.content))


def main():
    parser = argparse.ArgumentParser(description='Gets uid of user and creates sample basket in Test TRUST')
    parser.add_argument('--anonymous', dest='is_anonymous', action='store_true', required=False,
                        help='is anonymous payment')
    parser.add_argument('--ya_payments', dest='is_ya_payment', action = 'store_true', required=False, help='is Ya.Payment')
    parser.add_argument('--acquirer', dest='acquirer', required=False,
                        help='Ya.Payment acquirer(tinkoff or kassa)')
    parser.add_argument('--force_3ds', dest='should_force_3ds', action='store_true', required=False,
                        help='is Ya.Payment')
    parser.add_argument('--username', required=False, help='name of user')
    parser.add_argument('--password', required=False, help='password for user')
    parser.add_argument('--service_token', required=False, help='custom service token')
    parser.add_argument('--product_id', required=False, help='custom product_id')
    parser.add_argument('--out_format', required=False, default='kotlin', help='Format of output data(kotlin, curl, simple)')
    args = parser.parse_args()
    is_anonymous = args.is_anonymous
    ya_payment_acquirer = args.acquirer
    should_force_3ds = args.should_force_3ds
    is_ya_payment = args.is_ya_payment
    username = args.username
    password = args.password
    service_token = args.service_token
    if service_token is None:
        service_token = 'yandex_games_b9b09e9dcc29ef3063e10482b942aa59'
    product_id = args.product_id
    if product_id is None:
        product_id = "3136546516583745313514561"
    uid = None
    access_token = None
    if is_anonymous and is_ya_payment:
        print('--anonymous and --ya_payments are not compatible')
        exit(1)
    if not is_anonymous:
        params = {
            'grant_type': 'password',
            'username': username,
            'password': password,
            'client_id': '339e9a9d5bf346629394d7c8b4625c06',
            'client_secret': 'b9f4f6b80b674be8bdc0538ca0eb7b76',
            # 'client_id': '07cdfe530d2649e8a1ef8484fd50633d',
            # 'client_secret': '48e127d9cbf04954ade887b8b88c8248',
        }
        req = "https://oauth-test.yandex.ru/token"
        # req = "https://oauth.yandex.ru/token"
        res = requests.post(req, data=params, verify=False)
        if res.status_code == 200:
            res_map = json.loads(res.content)
            uid = res_map['uid']
            access_token = res_map['access_token']
        else:
            print('request to test-oauth for scope yastore:pay failed with code {} and response: {}'.format(
                res.status_code, res.content))
    else:
        handle_anon_basket(service_token, product_id, should_force_3ds)
        return
    if is_ya_payment:
        ya_payment_url = "https://payments-test-sdk.mail.yandex.net/v1/order"
        data = {
            "caption": "TestCaption",
            "description": "Test description",
            "items": [
                {
                    "name": "elephant",
                    "price": "100.00",
                    "nds": "nds_20",
                    "currency": "RUB",
                    "amount": 1
                }
            ]
        }
        purchase_token_resp = requests.post(ya_payment_url, json=data, headers={
            'Content-Type': 'application/json',
            'Authorization': acquirers_map[ya_payment_acquirer]
        }, verify=False)
        if int(purchase_token_resp.status_code / 100) == 2:
            puch_token_map = json.loads(purchase_token_resp.content)
            print('private val paymentToken = PaymentToken("{}")'.format(puch_token_map['data']['pay_token']))
            print('private val payer = Payer("{}", "{}@yandex.ru", "{}")'.format(access_token, username,
                                                                                 uid))
            print('private val merchant = Merchant("{}")'.format(merchants_map[ya_payment_acquirer]))
        else:
            print('error occurred during Ya.Payment basket creation, status {}, content: {}'.format(
                purchase_token_resp.status_code, purchase_token_resp.content))
    else:
        test_trust_url = "https://trust-payments-test.paysys.yandex.net:8028/trust-payments/v2/payments"
        seed(datetime.utcnow())
        data = {
            "amount": "100.0",
            "currency": "RUB",
            "product_id": product_id,
            "return_path": "https://yandex.ru/",
            "fiscal_nds": "nds_18",
            "fiscal_title": "PROD TITLE",
            "user_email": "payment-sdk-usr1@yandex.ru",
            "user_phone": "89998887766",
            # "payment_mode": 'api_payment'
        }
        if should_force_3ds:
            data["wait_for_cvn"] = 1
            data["pass_params"] = {
                "terminal_route_data": {
                    "service_force_3ds": 1
                }
            }
        purchase_token_resp = requests.post(test_trust_url, json=data, headers={
            'X-Uid': str(uid),
            'X-Service-Token': service_token
        }, verify=False)
        if int(purchase_token_resp.status_code / 100) == 2:
            puch_token_map = json.loads(purchase_token_resp.content)
            print('private val paymentToken = PaymentToken("{}")'.format(puch_token_map['purchase_token']))
            print('private val payer = Payer("{}", "{}@yandex.ru", "{}")'.format(res_map['access_token'], username,
                                                                                 uid))
            print('private val merchant = Merchant("yandex_games_b9b09e9dcc29ef3063e10482b942aa59")')
        else:
            print('error occurred during basket creation, status {}, content: {}'.format(
                purchase_token_resp.status_code, purchase_token_resp.content))


if __name__ == "__main__":
    main()


# card-x05f560a1e820cff39720b7a9
