#!/bin/bash

set -eu

OWNER="${OWNER:-g:mail-swat}"

search_path=$(pwd)
while [ "$search_path" != "/" ] ; do
    search_path=$(dirname "$search_path")
    if test -e "$search_path/ya"; then
        ARCADIA_ROOT=${search_path}
        break
    fi;
done

MOCKGEN_PATH=${ARCADIA_ROOT}/vendor/github.com/golang/mock/mockgen
MOCKGEN_BIN=${MOCKGEN_PATH}/mockgen
if [[ ! -f $MOCKGEN_BIN ]]; then
    echo "Mockgen is missing, building..."
    "${ARCADIA_ROOT}/ya" make "${MOCKGEN_PATH}"
fi
echo "Generating mock for $1..."
$MOCKGEN_BIN -destination=mocks/mocks.go -package=mocks . "$1"
echo "Mocks generated"
echo "Executing 'yo' to fix ya.make files..."
"${ARCADIA_ROOT}/ya" tool yo fix -add-owner="$OWNER" .

echo "Done"
