# Moderation

На текущий момент модерацию проходят продавцы и заказы.

#### Модерация заказов

Решение о необходимости отправить заказ на модерацию
зависит от нескольких факторов. Если заказ должен быть отправлен на модерацию,
то происходит это после получения ответа из платежной системы (траст) о заморозке средств на на счету покупателя.
Заказ переводится в pay_status IN_MODERATION и создается задача на отправку заказа в модерацию. Ответ модерации нужен,
чтобы либо подтвердить (clear) либо отвергнуть (unhold) замороженные средства клиента.

#### Отправка на модерацию

Отправка запросов на модерацию и получение результатов происходит при помощи асинхронных задачек.
Для отправки на модерацию каждый раз создается задача, соответствующего типа. 


#### Получение ответов модерации

Для чтения ответов модерации работает отдельный процесс, вычитывающий сообщений из логброкера и запускающий обработчик на каждое такое сообщение. Задача обработчика простая - найти запись модерации в базе и установить поля для результата
в соответствии с пришедшим ответом.

Ответов может прийти несколько, и чтобы не затереть новый ответ более старым,
мы обращаем внимание на временную метку unixtime в сообщение с ответом модерации.

После получения нового ответа модерации нужно отправить уведомление на почту продавца, для чего
обработчик ответов модерации, после сохранения результата в записи модерации, создает задачку
на уведомление.

Задачка уведомляющая о результате модерации сначала проверит, что результат все еще актуален,
и если это так, то задействует отправку письма на ящик продавца. Для отправки писем о статусе модерации используем 
транзакционные рассылки в сервисе рассылятор.

### Формат сообщений модерации

Запросы и ответы модерации используют JSON формат. За формирование сообщений отвечает класс ModerationProducer,
а за чтение сообщений &mdash; ModerationConsumer.

##### Вердикт модерации мерчанта

```json
{
    "meta": {
        "client_id": 5678,
        "id": 12345,
        "merchant_id": 543
    },
    "result": {
        "reasons": [1, 2],
        "verdict": "No"
    },
    "service": "pay",
    "type": "merchants",
    "unixtime": 100500
}
```

##### Вердикт модерации заказа

```json
{ 
  "service": "pay",
  "type": "order",
  "meta": {
    "id": 12345,
    "order_id": 111,
    "client_id": 5678
  },
  "result": {
    "verdict": "No",
    "reasons":  [1, 23]
  },
  "unixtime": 100500
}
```

Самые важные параметры ответа:
 - `meta.id` показывает идентификатор заявки на модерацию `moderation_id`, т. е. на что получили ответ
 - `result.verdict` - одобрить / отклонить
 - `result.reasons` - коды причин отмены

На уровень логики приложения результаты модерации пробрасываются через `ModerationConsumer` в виде итератора сущностей `ModerationResult`.
