### Запускаем локальный tvm демон
Запускаем tvm-демона локально с нужным конфигом:
```bash
tvmtool --port $TVM_PORT -a $TVM_TOKEN -c tvm_config.json
```

Конфигурационный файл для демона должен описывать наш сервис и куда наш сервис хочет ходить:
```json
{
    "clients": {
        "payments": {
            "secret": ...,
            "self_tvm_id": 2002162,
            "dsts": {
                "balance": {
                    "dst_id": 2000601
                },
                "payments-test": {
                    "dst_id": 2002162
                },
                "logbroker": {
                    "dst_id": 2001059
                },
                "mds": {
                    "dst_id": 2000272
                }
            }
        }
    }
}
```
- `payments` - имя нашего сервиса
- `self_tvm_id` - идентификатор тестового payments
- `secret` - секрет сервиса - можно узнать на ABC либо у коллег
- `dsts` - имена сервисов и их идентификаторы, куда наш сервис ходит с тикетами


### Запуск приложения локально

Для обращения к TVM-демону в конфигурации проекта есть несколько настроек в `*tvm.conf*`, описывающая адрес на локалхосте и имя приложения (=payments).
Однако помимо этого нужно будет задать пару переменных окружения, поскольку приложение разворачивается в qloud и для проверки тикетов используется пакет `sendr_tvm`, который конфигурирует клиентскую часть через переменные окружения:
- `QLOUD_TVM_TOKEN` - токен для обращения к демону TVM, передаваемый в заголовке авторизации - это в точности то, что мы передаем ключем `-a` демону при его запуске локально
- `QLOUD_TVM_CONFIG` - JSON-строка с конфигурацией для клиентской части - это тот же JSON с которым мы запустили твм-демона, только немного дополненный - нужно добавить ключ `"BbEnvType": 1` - это значит тестовое окружение. Судя по коду пакета из этой переменной окружения будет использоваться только значение BbEnvType и _наличие_ ключа clients.payments.

В общем перед стартом приложения нужно будет установить переменные окружения:
```bash
export QLOUD_TVM_TOKEN="$TVM_TOKEN"
export QLOUD_TVM_CONFIG='{"clients": {"payments": {"secret": "...", "self_tvm_id": 2002162, "dsts": {"balance": {"dst_id": 2000601}, "payments-test": {"dst_id": 2002162}, "logbroker": {"dst_id": 2001059}, "mds": {"dst_id": 2000272}}}}, "BbEnvType": 1}'
```

Команда старта приложения есть в Makefile.


### Запросы на локальный бэкенд

Чтобы делать запросы осталось выписать себе тикет (срок действия сутки). Запрос наподобие:
```bash
curl 'http://localhost:$TVM_PORT/tvm/tickets?dsts=2002162' -H 'Authorization: $TVM_TOKEN'
```

Должен ответить что-то вроде
```json
{
  "payments-test": {
    "ticket": "...",
    "tvm_id": 2002162
  }
}
```

Теперь для запросов на локальный бэкенд нужно будет указывать тикет в заголовке `X-Ya-Service-Ticket`.
