from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.arbitrage.order import (
    escalate_id_schema, get_order_response_schema, post_arbitrage_consultation_response_schema,
    post_arbitrage_verdict_request_schema
)
from mail.payments.payments.api.schemas.base import success_response_schema
from mail.payments.payments.api.schemas.path import order_uid_schema
from mail.payments.payments.conf import settings
from mail.payments.payments.core.actions.arbitrage.consultation import ConsultationArbitrageAction
from mail.payments.payments.core.actions.arbitrage.escalate import EscalateArbitrageAction
from mail.payments.payments.core.actions.arbitrage.get_order import GetOrderWithCurrentArbitrage
from mail.payments.payments.core.actions.arbitrage.verdict import VerdictArbitrageAction


class ArbitrageOrderHandler(BaseHandler):
    @request_schema(order_uid_schema, location='match_info')
    @response_schema(get_order_response_schema)
    async def get(self):
        data = await self.run_action(GetOrderWithCurrentArbitrage, await self.get_data())
        return self.make_response({'data': data}, get_order_response_schema)


class ArbitrageConsultationHandler(BaseHandler):
    @request_schema(order_uid_schema, location='match_info')
    @response_schema(post_arbitrage_consultation_response_schema)
    async def post(self):
        arbitrage = await self.run_action(ConsultationArbitrageAction, {
            **await self.get_data(),
            'customer_uid': self.tvm.default_uid if settings.CHECK_MERCHANT_USER else None
        })
        return self.make_response({'data': arbitrage}, post_arbitrage_consultation_response_schema)


class ArbitrageEscalateHandler(BaseHandler):
    @request_schema(order_uid_schema, location='match_info')
    @response_schema(post_arbitrage_consultation_response_schema)
    async def post(self):
        arbitrage = await self.run_action(EscalateArbitrageAction, {
            **await self.get_data(),
            'customer_uid': self.tvm.default_uid if settings.CHECK_MERCHANT_USER else None
        })
        return self.make_response({'data': arbitrage}, post_arbitrage_consultation_response_schema)


class ArbitrageVerdictHandler(BaseHandler):
    @request_schema(escalate_id_schema, location='query')
    @request_schema(post_arbitrage_verdict_request_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        await self.run_action(VerdictArbitrageAction, await self.get_data())
        return self.make_response({}, success_response_schema)
