from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.bank_requisites import (
    bank_requisites_request_schema, bank_requisites_response_schema
)
from mail.payments.payments.core.actions.interactions.bank_requisites import BankRequisitesAction
from mail.payments.payments.core.entities.bank_requisites import BankRequisites


class BankRequisitesHandler(BaseHandler):
    @request_schema(bank_requisites_request_schema, location='match_info')
    @response_schema(bank_requisites_response_schema)
    async def get(self):
        data: BankRequisites = await self.run_action(BankRequisitesAction, await self.get_data())
        return self.make_response({'data': data}, bank_requisites_response_schema)
