from sendr_aiohttp.handler import response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.category import get_category_list_response_schema
from mail.payments.payments.core.actions.category import GetCategoryListAction


class CategoryListHandler(BaseHandler):
    @response_schema(get_category_list_response_schema)
    async def get(self):
        categories = await self.run_action(GetCategoryListAction)
        return self.make_response({'data': {'categories': categories}}, get_category_list_response_schema)
