from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.base import success_response_schema
from mail.payments.payments.api.schemas.common_data import post_common_data_request_schema
from mail.payments.payments.core.actions.common_data import CreateCommonDataAction


class CommonDataHandler(BaseHandler):
    @request_schema(post_common_data_request_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        await self.run_action(CreateCommonDataAction, await self.get_data())
        return self.make_response({'data': {}}, success_response_schema)
