from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseMerchantUserHandler
from mail.payments.payments.api.schemas.customer_subscription import post_customer_subscription_request_schema
from mail.payments.payments.api.schemas.order_customer_subscription import customer_subscription_response_schema
from mail.payments.payments.api.schemas.path import customer_subscription_uid_schema, uid_request_schema
from mail.payments.payments.core.actions.customer_subscription.cancel import CancelCustomerSubscriptionAction
from mail.payments.payments.core.actions.customer_subscription.create import CreateCustomerSubscriptionAction


class CustomerSubscriptionHandler(BaseMerchantUserHandler):
    @request_schema(post_customer_subscription_request_schema, location='json')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(customer_subscription_response_schema)
    async def post(self):
        customer_subscription, order = await self.run_action(
            CreateCustomerSubscriptionAction,
            await self.get_data()
        )
        data = {'customer_subscription': customer_subscription, 'order': order}
        return self.make_response({'data': data}, customer_subscription_response_schema)


class CustomerSubscriptionCancelHandler(BaseMerchantUserHandler):
    @request_schema(customer_subscription_uid_schema, location='match_info')
    @response_schema(customer_subscription_response_schema)
    async def post(self):
        customer_subscription, order = await self.run_action(
            CancelCustomerSubscriptionAction,
            await self.get_data()
        )
        data = {'customer_subscription': customer_subscription, 'order': order}
        return self.make_response({'data': data}, customer_subscription_response_schema)
