from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseMerchantUserHandler
from mail.payments.payments.api.schemas.document import (
    delete_document_response_schema, get_document_response_schema, post_document_response_schema,
    uid_path_request_schema
)
from mail.payments.payments.api.schemas.path import uid_request_schema
from mail.payments.payments.core.actions.document import (
    DeleteDocumentAction, DownloadDocumentAction, GetDocumentsAction, UploadDocumentAction
)


class DocumentHandler(BaseMerchantUserHandler):
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(get_document_response_schema)
    async def get(self):
        data = await self.run_action(GetDocumentsAction, await self.get_data())
        return self.make_response({'data': data}, get_document_response_schema)

    @request_schema(uid_request_schema, location='match_info')
    @response_schema(post_document_response_schema)
    async def post(self):
        reader = await self.request.multipart()
        params = {
            **(await self.get_data()),
            'reader': reader,
        }
        data = await self.run_action(UploadDocumentAction, params)
        return self.make_response({'data': data}, post_document_response_schema)


class DocumentByPathHandler(BaseMerchantUserHandler):
    @request_schema(uid_path_request_schema, location='match_info')
    @response_schema(delete_document_response_schema)
    async def delete(self):
        await self.run_action(DeleteDocumentAction, await self.get_data())
        return self.make_response({'data': {}}, delete_document_response_schema)


class DocumentDownloadHandler(BaseMerchantUserHandler):
    @request_schema(uid_path_request_schema, location='match_info')
    async def get(self):
        headers, stream = await self.run_action(DownloadDocumentAction, await self.get_data())
        return await self.make_stream_response(headers, stream)
