from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.handlers.order import BaseOrderActiveHandler, BaseOrderHandler, BaseOrderListHandler
from mail.payments.payments.api.schemas.external.order import (
    get_order_external_response_schema, hash_request_schema, post_order_external_request_schema,
    post_order_external_response_schema, ref_request_schema
)
from mail.payments.payments.core.actions.order.get_by_hash import GetOrderByHashAction
from mail.payments.payments.core.actions.order.pay import PayOrderByHashAction
from mail.payments.payments.core.exceptions import CoreActionDenyError


class OrderByHashExternalHandler(BaseHandler):
    @request_schema(hash_request_schema, location='match_info')
    @response_schema(get_order_external_response_schema)
    async def get(self):
        data = await self.run_action(GetOrderByHashAction, await self.get_data())
        return self.make_response({'data': data}, get_order_external_response_schema)

    @request_schema(post_order_external_request_schema, location='json')
    @request_schema(hash_request_schema, location='match_info')
    @request_schema(ref_request_schema, location='query')
    @response_schema(post_order_external_response_schema)
    async def post(self):
        user_agent = self.request.headers.get('User-Agent', None)
        data = await self.run_action(PayOrderByHashAction, {
            **(await self.get_data()),
            'user_agent': user_agent,
            'overwrite_return_url': False,
            'select_customer_subscription': None,
        })
        return self.make_response({'data': data}, post_order_external_response_schema)


class OrderListExternalHandler(BaseOrderListHandler):
    async def get(self):
        try:
            raise CoreActionDenyError
        except CoreActionDenyError as e:
            self._core_exception_result(e)


class OrderExternalHandler(BaseOrderHandler):
    pass


class OrderActiveExternalHandler(BaseOrderActiveHandler):
    pass
