from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseMerchantUserHandler
from mail.payments.payments.api.schemas.merchant import (
    payments_graph_request_info_schema, payments_graph_request_query_schema, payments_graph_response_schema
)
from mail.payments.payments.core.actions.merchant.graph import MerchantPaymentsGraphAction


class PaymentsGraphHandler(BaseMerchantUserHandler):
    @request_schema(payments_graph_request_query_schema, location='query')
    @request_schema(payments_graph_request_info_schema, location='match_info')
    @response_schema(payments_graph_response_schema)
    async def get(self):
        payments_graph_points = await self.run_action(MerchantPaymentsGraphAction, await self.get_data())
        return self.make_response({'data': payments_graph_points}, payments_graph_response_schema)
