from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.internal.base import BaseInternalHandler
from mail.payments.payments.api.schemas.customer_subscription import post_customer_subscription_request_schema
from mail.payments.payments.api.schemas.internal.customer_subscription import (
    get_internal_customer_subscription_list_response_schema, get_internal_customer_subscription_request_schema
)
from mail.payments.payments.api.schemas.internal.order import (
    post_internal_order_start_request_schema, post_internal_order_start_response_schema
)
from mail.payments.payments.api.schemas.order_customer_subscription import customer_subscription_response_schema
from mail.payments.payments.api.schemas.path import (
    customer_subscription_service_merchant_schema, service_merchant_id_request_schema
)
from mail.payments.payments.core.actions.customer_subscription.cancel import (
    CancelCustomerSubscriptionServiceMerchantAction
)
from mail.payments.payments.core.actions.customer_subscription.create import (
    CreateCustomerSubscriptionServiceMerchantAction
)
from mail.payments.payments.core.actions.customer_subscription.get import GetCustomerSubscriptionServiceMerchantAction
from mail.payments.payments.core.actions.customer_subscription.get_list import (
    GetCustomerSubscriptionListServiceMerchantAction
)
from mail.payments.payments.core.actions.customer_subscription.pay import StartCustomerSubscriptionServiceMerchantAction


class InternalCustomerSubscriptionHandler(BaseInternalHandler):
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @request_schema(get_internal_customer_subscription_request_schema, location='query')
    @response_schema(get_internal_customer_subscription_list_response_schema)
    async def get(self):
        orders = await self.run_action(GetCustomerSubscriptionListServiceMerchantAction, await self.get_data())
        data = [
            {'customer_subscription': customer_subscription, 'order': order}
            for customer_subscription, order in orders
        ]
        return self.make_response({'data': data}, get_internal_customer_subscription_list_response_schema)

    @request_schema(post_customer_subscription_request_schema, location='json')
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(customer_subscription_response_schema)
    async def post(self):
        customer_subscription, order = await self.run_action(
            CreateCustomerSubscriptionServiceMerchantAction,
            await self.get_data()
        )
        data = {'customer_subscription': customer_subscription, 'order': order}
        return self.make_response({'data': data}, customer_subscription_response_schema)


class InternalCustomerSubscriptionIdHandler(BaseInternalHandler):
    @request_schema(customer_subscription_service_merchant_schema, location='match_info')
    @response_schema(customer_subscription_response_schema)
    async def get(self):
        customer_subscription, order = await self.run_action(
            GetCustomerSubscriptionServiceMerchantAction,
            await self.get_data()
        )
        data = {'customer_subscription': customer_subscription, 'order': order}
        return self.make_response({'data': data}, customer_subscription_response_schema)


class InternalStartCustomerSubscriptionHandler(BaseInternalHandler):
    @request_schema(post_internal_order_start_request_schema, location='json')
    @request_schema(customer_subscription_service_merchant_schema, location='match_info')
    @response_schema(post_internal_order_start_response_schema)
    async def post(self):
        data = await self.run_action(StartCustomerSubscriptionServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_order_start_response_schema)


class InternalCustomerSubscriptionCancelHandler(BaseInternalHandler):
    @request_schema(customer_subscription_service_merchant_schema, location='match_info')
    @response_schema(customer_subscription_response_schema)
    async def post(self):
        customer_subscription, order = await self.run_action(
            CancelCustomerSubscriptionServiceMerchantAction,
            await self.get_data()
        )
        data = {'customer_subscription': customer_subscription, 'order': order}
        return self.make_response({'data': data}, customer_subscription_response_schema)
