from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.exceptions import TVMUserTicketException
from mail.payments.payments.api.handlers.base import RequestMadeByUIDHandlerMixin
from mail.payments.payments.api.handlers.internal.base import BaseInternalHandler
from mail.payments.payments.api.schemas.internal.merchant import (
    post_internal_merchant_draft_request_schema, post_internal_merchant_draft_response_schema
)
from mail.payments.payments.api.schemas.path import uid_request_schema
from mail.payments.payments.core.actions.merchant.draft import CreateServiceMerchantDraftAction


class InternalMerchantDraftHandler(RequestMadeByUIDHandlerMixin, BaseInternalHandler):
    @request_schema(post_internal_merchant_draft_request_schema, location='json')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(post_internal_merchant_draft_response_schema)
    async def post(self):
        data = await self.get_data()

        uid = data.get('uid')
        autoenable = data.get('autoenable')
        if uid and autoenable and not self.request_is_made_by_uid(uid):
            raise TVMUserTicketException

        service_merchant, merchant = await self.run_action(CreateServiceMerchantDraftAction, data)
        data = {'merchant': merchant, 'service_merchant': service_merchant}
        return self.make_response({'data': data}, post_internal_merchant_draft_response_schema)
