from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.internal.base import BaseInternalHandler
from mail.payments.payments.api.handlers.order import PutOrderMixin
from mail.payments.payments.api.schemas.base import success_response_schema
from mail.payments.payments.api.schemas.internal.order import (
    active_internal_order_response_schema, get_internal_order_list_response_schema,
    get_internal_order_payout_info_schema, get_internal_order_request_schema, get_internal_order_response_schema,
    post_internal_order_request_schema, post_internal_order_resized_request_schema, post_internal_order_response_schema,
    post_internal_order_start_request_schema, post_internal_order_start_response_schema,
    post_internal_pay_offline_order_response_schema, post_internal_receipt_close_request_schema,
    post_internal_update_service_data_request_schema, post_internal_update_service_data_response_schema,
    put_internal_order_request_schema, put_internal_order_response_schema
)
from mail.payments.payments.api.schemas.order import (
    active_order_request_schema, get_order_list_request_schema, post_order_internal_clear_unhold_path_schema,
    post_refund_request_schema, post_refund_response_schema
)
from mail.payments.payments.api.schemas.path import (
    order_active_service_merchant_schema, order_service_merchant_schema, service_merchant_id_request_schema,
    shop_id_header_request_schema
)
from mail.payments.payments.core.actions.order.activate import ActivateOrderServiceMerchantAction
from mail.payments.payments.core.actions.order.cancel import CancelOrderServiceMerchantAction
from mail.payments.payments.core.actions.order.clear_unhold import ScheduleClearUnholdServiceMerchantOrderAction
from mail.payments.payments.core.actions.order.create_from_multi import CreateOrderFromMultiOrderServiceMerchantAction
from mail.payments.payments.core.actions.order.create_or_update import CreateOrUpdateOrderServiceMerchantAction
from mail.payments.payments.core.actions.order.get import (
    GetInternalOrderPayoutInfoAction, GetOrderServiceMerchantAction
)
from mail.payments.payments.core.actions.order.get_list import GetServiceMerchantOrderListAction
from mail.payments.payments.core.actions.order.pay import StartOrderAction
from mail.payments.payments.core.actions.order.pay_offline import PayOfflineServiceMerchantOrderAction
from mail.payments.payments.core.actions.order.receipt_close import OrderReceiptCloseServiceMerchantAction
from mail.payments.payments.core.actions.order.refund import CreateServiceMerchantRefundAction
from mail.payments.payments.core.actions.order.update_service_data import UpdateServiceDataServiceMerchantAction


class InternalOrderListHandler(BaseInternalHandler):
    @request_schema(get_order_list_request_schema, location='query')
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(get_internal_order_list_response_schema)
    async def get(self):
        data = await self.run_action(GetServiceMerchantOrderListAction, await self.get_data())
        return self.make_response({'data': data}, get_internal_order_list_response_schema)

    @request_schema(post_internal_order_request_schema, location='json')
    @request_schema(shop_id_header_request_schema, location='headers')
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(post_internal_order_response_schema)
    async def post(self):
        data = await self.run_action(CreateOrUpdateOrderServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_order_response_schema)


class InternalOrderHandler(PutOrderMixin, BaseInternalHandler):
    @request_schema(order_service_merchant_schema, location='match_info')
    @request_schema(get_internal_order_request_schema, location='query')
    @response_schema(get_internal_order_response_schema)
    async def get(self):
        params = {
            **(await self.get_data()),
            'with_customer_subscription': True,
            'select_customer_subscription': None,
        }
        data = await self.run_action(GetOrderServiceMerchantAction, params)
        return self.make_response({'data': data}, get_internal_order_response_schema)

    @request_schema(active_order_request_schema, location='json')
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(active_internal_order_response_schema)
    async def _active(self):
        self.logger.warning('Deprecated method for activate/deactivate order')
        data = await self.run_action(ActivateOrderServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, active_internal_order_response_schema)

    @request_schema(put_internal_order_request_schema, location='json')
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(put_internal_order_response_schema)
    async def _put(self):
        data = await self.run_action(CreateOrUpdateOrderServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, put_internal_order_response_schema)


class InternalOrderActiveHandler(BaseInternalHandler):
    @request_schema(order_active_service_merchant_schema, location='match_info')
    @response_schema(post_internal_order_response_schema)
    async def post(self):
        data = await self.run_action(ActivateOrderServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_order_response_schema)


class InternalMultiOrderHandler(BaseInternalHandler):
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(post_internal_order_response_schema)
    async def post(self):
        data = await self.run_action(CreateOrderFromMultiOrderServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_order_response_schema)


class InternalOrderStartHandler(BaseInternalHandler):
    @request_schema(post_internal_order_start_request_schema, location='json')
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(post_internal_order_response_schema)
    async def post(self):
        data = await self.run_action(StartOrderAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_order_start_response_schema)


class InternalPayOfflineOrderHandler(BaseInternalHandler):
    @request_schema(post_internal_order_start_request_schema, location='json')
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(post_internal_pay_offline_order_response_schema)
    async def post(self):
        data = await self.run_action(PayOfflineServiceMerchantOrderAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_pay_offline_order_response_schema)


class InternalOrderClearUnholdHandler(BaseInternalHandler):
    @request_schema(post_order_internal_clear_unhold_path_schema, location='match_info')
    @request_schema(post_internal_order_resized_request_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        await self.run_action(ScheduleClearUnholdServiceMerchantOrderAction, await self.get_data())
        return self.make_response({'data': {}}, success_response_schema)


class InternalRefundHandler(BaseInternalHandler):
    @request_schema(post_refund_request_schema, location='json')
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(post_refund_response_schema)
    async def post(self):
        data = await self.run_action(CreateServiceMerchantRefundAction, await self.get_data())
        return self.make_response({'data': data}, post_refund_response_schema)


class InternalUpdateServiceDataOrderHandler(BaseInternalHandler):
    @request_schema(order_service_merchant_schema, location='match_info')
    @request_schema(post_internal_update_service_data_request_schema, location='json')
    @response_schema(post_internal_update_service_data_response_schema)
    async def post(self):
        data = await self.run_action(UpdateServiceDataServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_update_service_data_response_schema)


class InternalReceiptCloseHandler(BaseInternalHandler):
    @request_schema(order_service_merchant_schema, location='match_info')
    @request_schema(post_internal_receipt_close_request_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        data = await self.run_action(OrderReceiptCloseServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, success_response_schema)


class InternalOrderCancelHandler(BaseInternalHandler):
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(post_internal_order_response_schema)
    async def post(self):
        data = await self.run_action(CancelOrderServiceMerchantAction, await self.get_data())
        return self.make_response({'data': data}, post_internal_order_response_schema)


class InternalOrderPayoutInfoHandler(BaseInternalHandler):
    @request_schema(order_service_merchant_schema, location='match_info')
    @response_schema(get_internal_order_payout_info_schema)
    async def get(self):
        params = await self.get_data()
        data = await self.run_action(GetInternalOrderPayoutInfoAction, params)
        return self.make_response({'data': data}, get_internal_order_payout_info_schema)
