from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.exceptions import TVMUserTicketException
from mail.payments.payments.api.handlers.internal.base import BaseInternalHandler
from mail.payments.payments.api.schemas.base import success_response_schema
from mail.payments.payments.api.schemas.internal.service import (
    service_merchant_request_schema, service_merchant_response_schema
)
from mail.payments.payments.api.schemas.path import service_merchant_id_request_schema
from mail.payments.payments.core.actions.merchant.get import GetMerchantAction
from mail.payments.payments.core.actions.service_merchant.create import CreateServiceMerchantAction
from mail.payments.payments.core.actions.service_merchant.delete import DeleteServiceMerchantServiceAction
from mail.payments.payments.core.actions.service_merchant.get import GetServiceMerchantServiceAction


class ServicePostHandler(BaseInternalHandler):
    @request_schema(service_merchant_request_schema, location='json')
    @response_schema(service_merchant_response_schema)
    async def post(self):
        data = await self.get_data()
        uid = data.get('uid')
        autoenable = data.get('autoenable')
        if uid and autoenable and self.tvm.default_uid != int(uid):
            raise TVMUserTicketException

        service_merchant, merchant = await self.run_action(CreateServiceMerchantAction, data)
        data = {'service_merchant': service_merchant, 'merchant': merchant}
        return self.make_response({'data': data}, service_merchant_response_schema)


class ServiceHandler(BaseInternalHandler):
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(service_merchant_response_schema)
    async def get(self):
        service_merchant = await self.run_action(GetServiceMerchantServiceAction, await self.get_data())
        merchant = await self.run_action(GetMerchantAction, {'uid': service_merchant.uid})
        data = {'service_merchant': service_merchant, 'merchant': merchant}
        return self.make_response({'data': data}, service_merchant_response_schema)

    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(success_response_schema)
    async def delete(self):
        await self.run_action(DeleteServiceMerchantServiceAction, await self.get_data())
        return self.make_response({'data': {}}, success_response_schema)
