from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.internal.base import BaseInternalHandler
from mail.payments.payments.api.schemas.path import (
    service_merchant_id_request_schema, subscription_service_merchant_schema
)
from mail.payments.payments.api.schemas.subscription import (
    get_subscription_request_schema, get_subscription_response_schema, post_subscription_request_schema,
    subscription_response_schema
)
from mail.payments.payments.core.actions.subscription.create import CreateSubscriptionServiceMerchantAction
from mail.payments.payments.core.actions.subscription.delete import DeleteSubscriptionServiceMerchantAction
from mail.payments.payments.core.actions.subscription.get import GetSubscriptionServiceMerchantAction
from mail.payments.payments.core.actions.subscription.get_list import GetSubscriptionListServiceMerchantAction


class InternalSubscriptionHandler(BaseInternalHandler):
    @request_schema(get_subscription_request_schema, location='query')
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(get_subscription_response_schema)
    async def get(self):
        subscriptions = await self.run_action(GetSubscriptionListServiceMerchantAction, await self.get_data())
        return self.make_response({'data': subscriptions}, get_subscription_response_schema)

    @request_schema(post_subscription_request_schema, location='json')
    @request_schema(service_merchant_id_request_schema, location='match_info')
    @response_schema(subscription_response_schema)
    async def post(self):
        subscription = await self.run_action(CreateSubscriptionServiceMerchantAction, await self.get_data())
        return self.make_response({'data': subscription}, subscription_response_schema)


class InternalSubscriptionIdHandler(BaseInternalHandler):
    @request_schema(subscription_service_merchant_schema, location='match_info')
    @response_schema(subscription_response_schema)
    async def get(self):
        subscription = await self.run_action(GetSubscriptionServiceMerchantAction, await self.get_data())
        return self.make_response({'data': subscription}, subscription_response_schema)

    @request_schema(subscription_service_merchant_schema, location='match_info')
    @response_schema(subscription_response_schema)
    async def delete(self):
        subscription = await self.run_action(DeleteSubscriptionServiceMerchantAction, await self.get_data())
        return self.make_response({'data': subscription}, subscription_response_schema)
