from aiohttp import web

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.core.actions.monitoring.ping_db import PingDBAction


class PingHandler(BaseHandler):
    async def get(self):
        return web.Response(text='pong')


class PingDBHandler(BaseHandler):
    async def get(self):
        await self.run_action(PingDBAction)
        return web.Response(text='pong')
