from aiohttp import web

from sendr_aiohttp import request_schema

from mail.payments.payments.api.handlers.base import BaseMerchantUserHandler
from mail.payments.payments.api.schemas.path import uid_request_schema
from mail.payments.payments.core.actions.offer import GetOfferAction


class OfferHandler(BaseMerchantUserHandler):
    @request_schema(uid_request_schema, location='match_info')
    async def get(self):
        headers, data = await self.run_action(GetOfferAction, await self.get_data())
        return web.Response(body=data, headers=headers)
