from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseMerchantUserHandler
from mail.payments.payments.api.schemas.path import uid_request_schema
from mail.payments.payments.api.schemas.report import (
    create_task_report_request_query_schema, download_report_request_schema, report_response_schema,
    reports_list_response_schema
)
from mail.payments.payments.core.actions.report import CreateTaskReportAction, DownloadReportAction, GetReportListAction


class ReportHandler(BaseMerchantUserHandler):
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(reports_list_response_schema)
    async def get(self):
        data = await self.run_action(GetReportListAction, await self.get_data())
        return self.make_response({'data': data}, reports_list_response_schema)

    @request_schema(create_task_report_request_query_schema, location='query')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(report_response_schema)
    async def post(self):
        task, report = await self.run_action(CreateTaskReportAction, await self.get_data())
        return self.make_response({'data': report}, report_response_schema)


class DowloadReportHandler(BaseMerchantUserHandler):
    @request_schema(download_report_request_schema, location='query')
    @request_schema(download_report_request_schema, location='match_info')
    async def get(self):
        content_type, data = await self.run_action(DownloadReportAction, await self.get_data())
        content_disposition = 'attachment; filename="report.csv"'
        headers = {
            'Content-Type': content_type,
            'Content-Disposition': content_disposition,
        }
        return await self.make_stream_response(headers, data)
