from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.sdk.order import post_order_start_response_schema, post_order_start_schema
from mail.payments.payments.core.actions.order.pay import StartOrderByPayTokenAction
from mail.payments.payments.core.entities.enums import OrderSource


class OrderStartHandler(BaseHandler):
    @request_schema(post_order_start_schema, location='json')
    @response_schema(post_order_start_response_schema)
    async def post(self):
        data = await self.run_action(
            StartOrderByPayTokenAction,
            {'pay_by_source': OrderSource.SDK_API, **(await self.get_data())},
        )
        return self.make_response({'data': data}, post_order_start_response_schema)
