from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.path import uid_request_schema
from mail.payments.payments.api.schemas.service import get_service_list_request_schema, get_service_list_response_schema
from mail.payments.payments.core.actions.service import GetServiceListAction, GetServiceListByServiceMerchantsAction


class ServiceListHandler(BaseHandler):
    @response_schema(get_service_list_response_schema)
    @request_schema(get_service_list_request_schema, location='query')
    async def get(self):
        services = await self.run_action(GetServiceListAction, await self.get_data())
        return self.make_response({'data': {'services': services}}, get_service_list_response_schema)


class ServiceListByServiceMerchantsHandler(BaseHandler):
    @response_schema(get_service_list_response_schema)
    @request_schema(uid_request_schema, location='match_info')
    async def get(self):
        services = await self.run_action(GetServiceListByServiceMerchantsAction, await self.get_data())
        return self.make_response({'data': {'services': services}}, get_service_list_response_schema)
