from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseHandler
from mail.payments.payments.api.schemas.path import shop_uid_schema, uid_request_schema
from mail.payments.payments.api.schemas.shop import (
    get_shop_list_request_schema, get_shop_list_response_schema, post_shop_list_request_schema,
    post_shop_list_response_schema, put_shop_request_schema, put_shop_response_schema
)
from mail.payments.payments.core.actions.shop.create_or_update import CreateOrUpdateShopAction
from mail.payments.payments.core.actions.shop.get_list import GetShopListAction


class ShopListHandler(BaseHandler):
    @request_schema(get_shop_list_request_schema, location='query')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(get_shop_list_response_schema)
    async def get(self):
        data = await self.run_action(GetShopListAction, {**await self.get_data(), 'with_merchant_oauth': True})
        return self.make_schema_response({'data': data}, get_shop_list_response_schema)

    @request_schema(post_shop_list_request_schema, location='json')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(post_shop_list_response_schema)
    async def post(self):
        data = await self.run_action(CreateOrUpdateShopAction, await self.get_data())
        return self.make_schema_response({'data': data}, post_shop_list_response_schema)


class ShopHandler(BaseHandler):
    @request_schema(put_shop_request_schema, location='json')
    @request_schema(shop_uid_schema, location='match_info')
    @response_schema(put_shop_response_schema)
    async def put(self):
        data = await self.run_action(CreateOrUpdateShopAction, await self.get_data())
        return self.make_schema_response({'data': data}, put_shop_response_schema)
