from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api.handlers.base import BaseMerchantUserHandler
from mail.payments.payments.api.schemas.path import subscription_uid_schema, uid_request_schema
from mail.payments.payments.api.schemas.subscription import (
    get_subscription_request_schema, get_subscription_response_schema, post_subscription_request_schema,
    subscription_response_schema
)
from mail.payments.payments.core.actions.subscription.create import CreateSubscriptionAction
from mail.payments.payments.core.actions.subscription.delete import DeleteSubscriptionAction
from mail.payments.payments.core.actions.subscription.get import GetSubscriptionAction
from mail.payments.payments.core.actions.subscription.get_list import GetSubscriptionListAction


class SubscriptionHandler(BaseMerchantUserHandler):
    @request_schema(get_subscription_request_schema, location='query')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(get_subscription_response_schema)
    async def get(self):
        subscriptions = await self.run_action(GetSubscriptionListAction, await self.get_data())
        return self.make_response({'data': subscriptions}, get_subscription_response_schema)

    @request_schema(post_subscription_request_schema, location='json')
    @request_schema(uid_request_schema, location='match_info')
    @response_schema(subscription_response_schema)
    async def post(self):
        subscription = await self.run_action(CreateSubscriptionAction, await self.get_data())
        return self.make_response({'data': subscription}, subscription_response_schema)


class SubscriptionIdHandler(BaseMerchantUserHandler):
    @request_schema(subscription_uid_schema, location='match_info')
    @response_schema(subscription_response_schema)
    async def get(self):
        subscription = await self.run_action(GetSubscriptionAction, await self.get_data())
        return self.make_response({'data': subscription}, subscription_response_schema)

    @request_schema(subscription_uid_schema, location='match_info')
    @response_schema(subscription_response_schema)
    async def delete(self):
        subscription = await self.run_action(DeleteSubscriptionAction, await self.get_data())
        return self.make_response({'data': subscription}, subscription_response_schema)
