from mail.payments.payments.api.handlers.arbitrage.order import (
    ArbitrageConsultationHandler, ArbitrageEscalateHandler, ArbitrageOrderHandler, ArbitrageVerdictHandler
)
from mail.payments.payments.api.routes.base import PrefixedUrl


class Url(PrefixedUrl):
    PREFIX = '/v1/arbitrage'


ARBITRAGE_ROUTES = (
    Url(r'/order/{uid:\d+}/{order_id:\d+}', ArbitrageOrderHandler, name='arbitrage_order_handler'),
    Url(
        r'/order/{uid:\d+}/{order_id:\d+}/consultation',
        ArbitrageConsultationHandler,
        name='arbitrage_consultation_handler'
    ),
    Url(
        r'/order/{uid:\d+}/{order_id:\d+}/escalate',
        ArbitrageEscalateHandler,
        name='arbitrage_escalate_handler'
    ),
    Url(
        r'/conversation/verdict',
        ArbitrageVerdictHandler,
        name='arbitrage_verdict_handler'
    ),
)
