from typing import ClassVar

from sendr_aiohttp import BaseUrlDispatcher, Url


class UrlDispatcher(BaseUrlDispatcher):
    def add_routes(self, urls):
        for url in urls:
            if isinstance(url, Url):
                url.validate()
                self.add_route(url.method, url.path, url.handler, name=url.name)
            else:
                self.add_route(url.method, url.path, url.handler, name=None)


class PrefixedUrl(Url):
    PREFIX: ClassVar[str]

    def __init__(self, path, handler, name=None, method='*'):
        super().__init__(self.PREFIX + path, handler, name, method)
