from mail.payments.payments.api.handlers.external.order import (
    OrderActiveExternalHandler, OrderByHashExternalHandler, OrderExternalHandler, OrderListExternalHandler
)
from mail.payments.payments.api.routes.base import PrefixedUrl


class Url(PrefixedUrl):
    PREFIX = '/ext'


EXTERNAL_ROUTES = (
    # Order
    Url(r'/order/{uid:\d+}', OrderListExternalHandler, name='ext_order_list'),
    Url(r'/order/{uid:\d+}/{order_id:\d+}', OrderExternalHandler, name='ext_order'),
    Url(
        r'/order/{uid:\d+}/{order_id:\d+}/{operation:(deactivate|activate)}',
        OrderActiveExternalHandler,
        name='ext_order_active'
    ),

    # Provides access to order via crypto-text. POST request is used to start payment
    Url(r'/{hash}', OrderByHashExternalHandler, name='ext_order_hash'),
)
