from sendr_aiohttp import Url, get_live_handler, get_ping_handler
from sendr_qstats.http.aiohttp import get_registry_handler

from mail.payments.payments.api.handlers.callback import CallbackHandler
from mail.payments.payments.api.handlers.internal.customer_subscription import (
    InternalCustomerSubscriptionCancelHandler, InternalCustomerSubscriptionHandler,
    InternalCustomerSubscriptionIdHandler, InternalStartCustomerSubscriptionHandler
)
from mail.payments.payments.api.handlers.internal.merchant import InternalMerchantDraftHandler
from mail.payments.payments.api.handlers.internal.order import (
    InternalMultiOrderHandler, InternalOrderActiveHandler, InternalOrderCancelHandler, InternalOrderClearUnholdHandler,
    InternalOrderHandler, InternalOrderListHandler, InternalOrderPayoutInfoHandler, InternalOrderStartHandler,
    InternalPayOfflineOrderHandler, InternalReceiptCloseHandler, InternalRefundHandler,
    InternalUpdateServiceDataOrderHandler
)
from mail.payments.payments.api.handlers.internal.service import ServiceHandler, ServicePostHandler
from mail.payments.payments.api.handlers.internal.subscription import (
    InternalSubscriptionHandler, InternalSubscriptionIdHandler
)
from mail.payments.payments.api.handlers.monitoring import PingDBHandler
from mail.payments.payments.api.routes.base import PrefixedUrl
from mail.payments.payments.conf import settings
from mail.payments.payments.utils.stats import REGISTRY


class UrlInternal(PrefixedUrl):
    PREFIX = '/v1/internal'


INTERNAL_ROUTES = (
    # Handles trust callback
    Url(r'/callback/payment/{uid}/{order_id}', CallbackHandler, name='trust_callback'),

    # Monitoring
    Url(r'/ping', get_ping_handler(), name='ping'),
    Url(r'/live', get_live_handler(), name='live'),
    Url(r'/pingdb', PingDBHandler, name='pingdb'),

    # Service
    UrlInternal(r'/service', ServicePostHandler, name='internal_service_post'),
    UrlInternal(r'/service/{service_merchant_id:\d+}', ServiceHandler, name='internal_service'),

    # Merchant
    UrlInternal(r'/merchant/{uid:\d+}/draft', InternalMerchantDraftHandler, name='internal_merchant_draft'),

    # Subscription
    UrlInternal(r'/subscription/{service_merchant_id:\d+}', InternalSubscriptionHandler, name='internal_subscriptions'),
    UrlInternal(
        r'/subscription/{service_merchant_id:\d+}/{subscription_id:\d+}',
        InternalSubscriptionIdHandler,
        name='internal_subscription_get'
    ),

    # Customer subscription
    UrlInternal(
        r'/customer_subscription/{service_merchant_id:\d+}',
        InternalCustomerSubscriptionHandler,
        name='internal_customer_subscription'
    ),
    UrlInternal(
        r'/customer_subscription/{service_merchant_id:\d+}/{customer_subscription_id:\d+}',
        InternalCustomerSubscriptionIdHandler,
        name='internal_customer_subscription_get'
    ),
    UrlInternal(
        r'/customer_subscription/{service_merchant_id:\d+}/{customer_subscription_id:\d+}/start',
        InternalStartCustomerSubscriptionHandler,
        name='internal_customer_subscription_start'
    ),
    UrlInternal(
        r'/customer_subscription/{service_merchant_id:\d+}/{customer_subscription_id:\d+}/cancel',
        InternalCustomerSubscriptionCancelHandler,
        name='internal_customer_subscription_cancel'
    ),

    # Order
    UrlInternal(r'/order/{service_merchant_id:\d+}/', InternalOrderListHandler, name='internal_order_list_compat'),
    UrlInternal(r'/order/{service_merchant_id:\d+}', InternalOrderListHandler, name='internal_order_list'),

    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/{operation:(deactivate|activate)}',
        InternalOrderActiveHandler,
        name='internal_order_active'
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/multi/{order_id:\d+}',
        InternalMultiOrderHandler,
        name='internal_multi_order'
    ),
    UrlInternal(r'/order/{service_merchant_id:\d+}/{order_id:\d+}', InternalOrderHandler, name='internal_order'),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/start',
        InternalOrderStartHandler,
        name='internal_order_start'
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/pay_offline',
        InternalPayOfflineOrderHandler,
        name='internal_order_pay_offline'
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/refund',
        InternalRefundHandler,
        name='internal_refund',
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/{operation:(clear|unhold)}',
        InternalOrderClearUnholdHandler,
        name='internal_order_clear_unhold',
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/cancel',
        InternalOrderCancelHandler,
        name='internal_order_cancel'
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/service_data',
        InternalUpdateServiceDataOrderHandler,
        name='internal_order_service_data',
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/receipt/close',
        InternalReceiptCloseHandler,
        name='internal_order_receipt_close',
    ),
    UrlInternal(
        r'/order/{service_merchant_id:\d+}/{order_id:\d+}/payout_info',
        InternalOrderPayoutInfoHandler,
        name='internal_order_payout_info',
    ),

    # Stat
    Url(settings.STATS_URL, get_registry_handler(handle_registry=REGISTRY), name='stats')
)
