from mail.payments.payments.api.handlers.bank_requisites import BankRequisitesHandler
from mail.payments.payments.api.handlers.category import CategoryListHandler
from mail.payments.payments.api.handlers.common_data import CommonDataHandler
from mail.payments.payments.api.handlers.customer_subscription import (
    CustomerSubscriptionCancelHandler, CustomerSubscriptionHandler
)
from mail.payments.payments.api.handlers.document import DocumentByPathHandler, DocumentDownloadHandler, DocumentHandler
from mail.payments.payments.api.handlers.graph import PaymentsGraphHandler
from mail.payments.payments.api.handlers.merchant import (
    MccHandler, MerchantByDeveloperKeyHandler, MerchantDraftHandler, MerchantHandler, MerchantModerationHandler,
    MerchantOAuthCompleteHandler, MerchantOAuthHandler, MerchantOAuthStartHandler, MerchantOrdersStatsHandler,
    MerchantPreregisterHandler, MerchantServiceHandler, MerchantServiceListHandler, MerchantSuggestHandler,
    MerchantTokenHandler
)
from mail.payments.payments.api.handlers.offer import OfferHandler
from mail.payments.payments.api.handlers.order import (
    CancelHandler, DownloadMultiOrderEmailListHandler, MultiOrderHandler, OrderActiveHandler, OrderClearUnholdHandler,
    OrderEmailHandler, OrderHandler, OrderListHandler, PayOfflineOrderHandler,
    RefundCustomerSubscriptionTransactionHandler, RefundHandler
)
from mail.payments.payments.api.handlers.report import DowloadReportHandler, ReportHandler
from mail.payments.payments.api.handlers.service import ServiceListByServiceMerchantsHandler, ServiceListHandler
from mail.payments.payments.api.handlers.shop import ShopHandler, ShopListHandler
from mail.payments.payments.api.handlers.subscription import SubscriptionHandler, SubscriptionIdHandler
from mail.payments.payments.api.handlers.user_role import MerchantUserRoleHandler, UserRoleHandler
from mail.payments.payments.api.routes.base import PrefixedUrl


class Url(PrefixedUrl):
    PREFIX = '/v1'


V1_ROUTES = (
    # Documents
    Url(r'/document/{uid:\d+}', DocumentHandler, name='v1_document'),
    Url(r'/document/{uid:\d+}/{path:.+}/download', DocumentDownloadHandler, name='v1_document_download'),
    Url(r'/document/{uid:\d+}/{path:.+}', DocumentByPathHandler, name='v1_document_by_key'),

    # Merchant
    Url(r'/merchant/{uid:\d+}', MerchantHandler, name='v1_merchant'),
    Url(r'/merchant/{uid:\d+}/draft', MerchantDraftHandler, name='v1_merchant_draft'),
    Url(r'/merchant/{uid:\d+}/preregister', MerchantPreregisterHandler, name='v1_merchant_preregister'),
    Url(r'/merchant/{uid:\d+}/moderation', MerchantModerationHandler, name='v1_merchant_moderation'),
    Url(r'/merchant/{uid:\d+}/token', MerchantTokenHandler, name='v1_merchant_token'),
    Url(r'/merchant/{uid:\d+}/service', MerchantServiceListHandler, name='v1_merchant_service_list'),
    Url(r'/merchant/{uid:\d+}/service/{service_merchant_id:\d+}', MerchantServiceHandler, name='v1_merchant_service'),
    Url(r'/merchant/{uid:\d+}/oauth', MerchantOAuthHandler, name='v1_merchant_oauth'),
    Url(r'/merchant/{uid:\d+}/oauth/start', MerchantOAuthStartHandler, name='v1_merchant_oauth_start'),
    Url(r'/merchant/{uid:\d+}/oauth/complete', MerchantOAuthCompleteHandler, name='v1_merchant_oauth_complete'),
    Url(r'/merchant/{uid:\d+}/mcc', MccHandler, name='v1_mcc_info'),
    Url(r'/merchant/{uid:\d+}/orders_stats', MerchantOrdersStatsHandler, name='v1_orders_stats'),
    Url(r'/merchant/{merchant_id}/user_role', MerchantUserRoleHandler, name='v1_merchant_user_role'),
    Url(r'/merchant/suggest', MerchantSuggestHandler, name='v1_merchant_suggest'),

    # User Role
    Url(r'/user_role/{uid:\d+}', UserRoleHandler, name='v1_user_role'),

    # Returns merchant by it's developer key. PAYBACK-50
    Url(r'/merchant_by_key/{key:.+}', MerchantByDeveloperKeyHandler, name='v1_merchant_by_key'),

    # Offer
    Url(r'/offer/{uid:\d+}', OfferHandler, name='v1_offer'),

    # Order
    Url(r'/order/{uid:\d+}/', OrderListHandler, name='v1_order_list_compat'),
    Url(r'/order/{uid:\d+}', OrderListHandler, name='v1_order_list'),
    Url(r'/order/{uid:\d+}/multi/{order_id:\d+}', MultiOrderHandler, name='v1_multi_order'),
    Url(
        r'/order/{uid:\d+}/multi/{order_id:\d+}/download',
        DownloadMultiOrderEmailListHandler,
        name='v1_download_multi_order_emails'
    ),
    Url(r'/order/{uid:\d+}/{order_id:\d+}', OrderHandler, name='v1_order'),
    Url(r'/order/{uid:\d+}/{order_id:\d+}/pay_offline', PayOfflineOrderHandler, name='v1_order_pay_offline'),
    Url(r'/order/{uid:\d+}/{order_id:\d+}/email', OrderEmailHandler, name='v1_order_email'),
    Url(r'/order/{uid:\d+}/{order_id:\d+}/refund', RefundHandler, name='v1_refund'),
    Url(r'/order/{uid:\d+}/{order_id:\d+}/cancel', CancelHandler, name='v1_order_cancel'),
    Url(
        r'/order/{uid:\d+}/{order_id:\d+}/{operation:(deactivate|activate)}',
        OrderActiveHandler,
        name='v1_order_active'
    ),
    Url(
        r'/order/{uid:\d+}/{order_id:\d+}/{operation:(clear|unhold)}',
        OrderClearUnholdHandler,
        name='v1_order_clear_unhold',
    ),

    # Graph
    Url(r'/graph/{uid:\d+}/{graph_type}', PaymentsGraphHandler, name='v1_payments_graph'),

    # Report
    Url(r'/report/{uid:\d+}', ReportHandler, name='v1_payments_report'),
    Url(r'/report/{uid:\d+}/download/{report_id:.+}', DowloadReportHandler, name='v1_download_report'),

    # Service
    Url(r'/service', ServiceListHandler, name='v1_payments_service_list'),
    Url(r'/service/{uid:\d+}', ServiceListByServiceMerchantsHandler, name='v1_payments_merchant_service_list'),

    # Category
    Url(r'/category', CategoryListHandler, name='v1_payments_category_list'),

    # Shop
    Url(r'/shop/{uid:\d+}', ShopListHandler, name='v1_shop_list'),
    Url(r'/shop/{uid:\d+}/{shop_id:\d+}', ShopHandler, name='v1_shop'),

    # Refs
    Url(r'/refs/bank/{bic:\d+}', BankRequisitesHandler, name='v1_bank_requisites'),

    # Subscription
    Url(r'/subscription/{uid:\d+}', SubscriptionHandler, name='v1_subscriptions'),
    Url(r'/subscription/{uid:\d+}/{subscription_id:\d+}', SubscriptionIdHandler, name='v1_subscription_get'),

    # Customer subscription
    Url(r'/customer_subscription/{uid:\d+}', CustomerSubscriptionHandler, name='v1_customer_subscription'),
    Url(
        r'/customer_subscription/{uid:\d+}/{customer_subscription_id:\d+}/cancel',
        CustomerSubscriptionCancelHandler,
        name='v1_customer_subscription_cancel'
    ),
    Url(
        r'/customer_subscription/{uid:\d+}/{customer_subscription_id:\d+}/{purchase_token:.+}/refund',
        RefundCustomerSubscriptionTransactionHandler,
        name='v1_customer_subscription_tx_refund'
    ),

    # Other
    Url(r'/data', CommonDataHandler, name='v1_data'),
)
