from marshmallow import fields, validate

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema


class BankRequisitesRequestSchema(BaseSchema):
    BIC_REGEXP = '^[0-9]{9}$'

    bic = fields.String(required=True, validate=validate.Regexp(BIC_REGEXP))


class BankRequisitesSchema(BaseSchema):
    bic = fields.String()
    name_full = fields.String()
    corr = fields.String()


class BankRequisitesResponseSchema(SuccessResponseSchema):
    data = fields.Nested(BankRequisitesSchema)


bank_requisites_request_schema = BankRequisitesRequestSchema()
bank_requisites_response_schema = BankRequisitesResponseSchema()
