from marshmallow import fields
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.core.entities.enums import AcquirerType


class CategorySchema(BaseSchema):
    category_id = fields.Integer()
    title = fields.String()
    required_acquirer = EnumField(AcquirerType, by_value=True, allow_none=True, required=False)


class CategoryListSchema(BaseSchema):
    categories = fields.Nested(CategorySchema, many=True)


class GetCategoryListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(CategoryListSchema)


get_category_list_response_schema = GetCategoryListResponseSchema()
