from marshmallow import ValidationError, fields, validates_schema

from mail.payments.payments.api.schemas.base import BaseSchema
from mail.payments.payments.api.schemas.subscription import SubscriptionSchema


class CustomerSubscription(BaseSchema):
    customer_subscription_id = fields.Integer(dump_only=True)
    order_id = fields.Integer(dump_only=True)
    user_ip = fields.String()
    region_id = fields.Integer()
    quantity = fields.Integer()
    enabled = fields.Boolean(dump_only=True)
    time_until = fields.DateTime(dump_only=True)
    time_finish = fields.DateTime(dump_only=True)
    subscription = fields.Nested(SubscriptionSchema)


class PostCustomerSubscriptionRequestSchema(BaseSchema):
    subscription_id = fields.Integer(required=True)
    customer_uid = fields.Integer()
    user_ip = fields.String()
    region_id = fields.Integer()
    quantity = fields.Integer(default=1)
    paymethod_id = fields.Constant('trust_web_page')  # Запрещаем через API передавать своё значение

    @validates_schema
    def validate_schema(self, data):
        if data.get('user_ip') is None and data.get('region_id') is None:
            raise ValidationError('user_ip or region_id should be pass')


post_customer_subscription_request_schema = PostCustomerSubscriptionRequestSchema()
