from marshmallow import fields
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.api.schemas.fields import NestedWithKey
from mail.payments.payments.api.schemas.path import UIDRequestSchema
from mail.payments.payments.core.entities.enums import DocumentType


class DocumentImageSchema(BaseSchema):
    document_type = EnumField(DocumentType, by_value=True)
    path = fields.String()
    size = fields.Integer()
    created = fields.DateTime()
    name = fields.String()


class GetDocumentsResponseSchema(SuccessResponseSchema):
    data = NestedWithKey(DocumentImageSchema, 'document_type', many_per_key=True)


class PostDocumentResponseSchema(SuccessResponseSchema):
    data = fields.Nested(DocumentImageSchema)


class UIDPathRequestSchema(UIDRequestSchema):
    path = fields.String(required=True)


get_document_response_schema = GetDocumentsResponseSchema()
post_document_response_schema = PostDocumentResponseSchema()
delete_document_response_schema = SuccessResponseSchema()
uid_path_request_schema = UIDPathRequestSchema()
