from marshmallow import fields, validate

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.api.schemas.fields import StripString
from mail.payments.payments.api.schemas.merchant import DumpMerchantSchema
from mail.payments.payments.api.schemas.order import OrderSchema
from mail.payments.payments.api.schemas.transaction import TransactionSchema


class HashRequestSchema(BaseSchema):
    hash_ = fields.String(load_from='hash')


class MerchantOrderTransactionSchema(BaseSchema):
    order = fields.Nested(OrderSchema)
    merchant = fields.Nested(DumpMerchantSchema())
    transaction = fields.Nested(TransactionSchema)


class PaymentUrlSchema(BaseSchema):
    payment_url = fields.String()


class GetOrderExternalResponseSchema(SuccessResponseSchema):
    data = fields.Nested(MerchantOrderTransactionSchema)


class PostOrderExternalRequestSchema(BaseSchema):
    email = StripString(required=True)
    return_url = fields.String(required=True)
    yandexuid = fields.String(allow_none=True)
    customer_uid = fields.Integer(missing=None, allow_none=True)
    description = fields.String()
    template = fields.String(validate=validate.OneOf(['mobile', 'desktop']))
    trust_form_name = fields.String()


class PostOrderExternalResponseSchema(SuccessResponseSchema):
    data = fields.Nested(PaymentUrlSchema)


class RefererRequestSchema(BaseSchema):
    referer = fields.String(load_from='ref')


hash_request_schema = HashRequestSchema()

get_order_external_response_schema = GetOrderExternalResponseSchema()

post_order_external_request_schema = PostOrderExternalRequestSchema()
post_order_external_response_schema = PostOrderExternalResponseSchema()

ref_request_schema = RefererRequestSchema()
