from sendr_utils.schemas.base import BaseSchema

from mail.payments.payments.core.entities.enums import FunctionalityType, YandexPayPartnerType
from mail.payments.payments.schemas.functionality import (
    FunctionalityPaymentsSchema, FunctionalitySchema, FunctionalityYandexPayMerchantSchema,
    FunctionalityYandexPayPaymentGatewaySchema, FunctionalityYandexPaySchema
)


class FunctionalityYandexPayPaymentGatewayAPISchema(FunctionalityYandexPayPaymentGatewaySchema):
    class Meta(BaseSchema.Meta):
        dump_only = ('partner_id',)


class FunctionalityYandexPayMerchantAPISchema(FunctionalityYandexPayMerchantSchema):
    class Meta(BaseSchema.Meta):
        dump_only = ('partner_id',)


class FunctionalityYandexPayAPISchema(FunctionalityYandexPaySchema):
    type_schemas = {
        YandexPayPartnerType.MERCHANT.value: FunctionalityYandexPayMerchantAPISchema,
        YandexPayPartnerType.PAYMENT_GATEWAY.value: FunctionalityYandexPayPaymentGatewayAPISchema,
    }


class FunctionalityAPISchema(FunctionalitySchema):
    type_schemas = {
        FunctionalityType.PAYMENTS.value: FunctionalityPaymentsSchema,
        FunctionalityType.YANDEX_PAY.value: FunctionalityYandexPayAPISchema,
    }
