from marshmallow import fields

from mail.payments.payments.api.schemas.base import BasePaginatedRequestSchema, SuccessResponseSchema
from mail.payments.payments.api.schemas.order_customer_subscription import OrderCustomerSubscriptionSchema


class GetInternalCustomerSubscriptionRequestSchema(BasePaginatedRequestSchema):
    subscription_id = fields.Integer()


class GetInternalCustomerSubscriptionListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(OrderCustomerSubscriptionSchema, many=True)


get_internal_customer_subscription_request_schema = GetInternalCustomerSubscriptionRequestSchema()
get_internal_customer_subscription_list_response_schema = GetInternalCustomerSubscriptionListResponseSchema()
