from marshmallow import fields, pre_dump

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.api.schemas.merchant import (
    CreateMerchantDraftSchema, DumpMerchantSchema, ServiceMerchantSchema
)


class InternalCreateMerchantDraftSchema(CreateMerchantDraftSchema):
    entity_id = fields.String(required=True)
    description = fields.String(required=True)
    autoenable = fields.Boolean()


class InternalServiceMerchantSchema(ServiceMerchantSchema):
    class Meta:
        exclude = ('service',)


class InternalMerchantDraftDataResponseSchema(BaseSchema):
    merchant = fields.Nested(DumpMerchantSchema)
    service_merchant = fields.Nested(InternalServiceMerchantSchema)

    @pre_dump
    def pre_dump(self, data):
        merchant = data['merchant']
        service_merchant = data['service_merchant']

        return {
            'merchant': merchant,
            'service_merchant': {
                'service_merchant': service_merchant,
                'merchant': merchant
            },
        }


class InternalMerchantDraftResponseSchema(SuccessResponseSchema):
    data = fields.Nested(InternalMerchantDraftDataResponseSchema)


post_internal_merchant_draft_request_schema = InternalCreateMerchantDraftSchema()
post_internal_merchant_draft_response_schema = InternalMerchantDraftResponseSchema()
