from marshmallow import ValidationError, fields, validates_schema

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.api.schemas.merchant import ServiceMerchantSchema


class ServiceMerchantRequestSchema(BaseSchema):
    uid = fields.Integer()
    token = fields.String(required=True)
    entity_id = fields.String(required=True)
    description = fields.String(required=True)
    autoenable = fields.Boolean()

    @validates_schema
    def validate_uid_token(self, data):
        if not data.get('uid') and data.get('autoenable'):
            raise ValidationError('autoenable should be passed only with uid')


class ServiceMerchantResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ServiceMerchantSchema)


service_merchant_request_schema = ServiceMerchantRequestSchema()
service_merchant_response_schema = ServiceMerchantResponseSchema()
