from marshmallow import fields

from mail.payments.payments.api.schemas.base import BaseSchema
from mail.payments.payments.api.schemas.fields import QueryParamList


class MccSchema(BaseSchema):
    code = fields.Integer(required=True)
    name_ru = fields.String(required=True)
    name = fields.String(required=True)
    source = fields.String()
    mcc_group = fields.Dict()
    clearing_name = fields.String()


class MccResponseSchema(BaseSchema):
    data = fields.Nested(MccSchema, many=True)


class MccRequestSchema(BaseSchema):
    codes = QueryParamList(fields.Integer())


mcc_request_schema = MccRequestSchema()
mcc_response_schema = MccResponseSchema()
