from marshmallow import fields, validate

from mail.payments.payments.api.schemas.base import BaseSchema
from mail.payments.payments.api.schemas.functionality import FunctionalityAPISchema
from mail.payments.payments.api.schemas.merchant import AddressSchema, BankSchema, OrganizationSchema, PersonSchema


class PersonSchemaNone(PersonSchema):
    skip_nones = False


class PersonsPartialSchemaNone(BaseSchema):
    # Если использовать BaseListDictSchema, нет возможности отличить случай, когда передали None, от случая,
    # когда передали пустой объект
    skip_nones = False

    ceo = fields.Nested(PersonSchemaNone(partial=True))
    contact = fields.Nested(PersonSchemaNone(partial=True), allow_none=True)
    signer = fields.Nested(PersonSchemaNone(partial=True), allow_none=True)


class AddressSchemaNone(AddressSchema):
    skip_nones = False


class AddressesPartialSchemaNone(BaseSchema):
    skip_nones = False

    legal = fields.Nested(AddressSchemaNone(partial=True))
    post = fields.Nested(AddressSchemaNone(partial=True), allow_none=True)


class BankSchemaNone(BankSchema):
    skip_nones = False


class OrganizationSchemaNone(OrganizationSchema):
    skip_nones = False

    site_url = fields.String(dump_to='siteUrl',
                             load_from='siteUrl',
                             validate=validate.Regexp(OrganizationSchema.SITE_URL),
                             allow_none=True)


class UpdateMerchantSchema(BaseSchema):
    skip_nones = False

    name = fields.String(allow_none=True)
    username = fields.String(allow_none=True)
    addresses = fields.Nested(AddressesPartialSchemaNone, allow_none=True)
    bank = fields.Nested(BankSchemaNone(partial=True), allow_none=True)
    organization = fields.Nested(OrganizationSchemaNone(partial=True), allow_none=True)
    persons = fields.Nested(PersonsPartialSchemaNone, allow_none=True)
    functionality = fields.Nested(FunctionalityAPISchema, allow_none=True)


merchant_update_request_schema = UpdateMerchantSchema()
