from marshmallow import fields, post_dump

from mail.payments.payments.conf import settings


class DumpSkipEmpty:
    @post_dump
    def skip_empty(self, data):
        return {
            key: value
            for key, value in data.items()
            if value is not None
        }


class PayTokenMixin:
    pay_token = fields.String(dump_only=True, attribute='payment_hash')

    @post_dump
    def create_pay_token(self, data):
        # Префикс нужен для отличия pay_token от какой-либо другой строки в base64 по просьбе команды SDK
        data['pay_token'] = f'{settings.PAY_TOKEN_PREFIX}{data["pay_token"]}'
        return data
