from marshmallow import fields, pre_dump
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BaseSchema
from mail.payments.payments.core.entities.enums import FunctionalityType


class ModerationSchema(BaseSchema):
    approved = fields.Boolean()
    has_moderation = fields.Boolean(dump_to='hasModeration')
    has_ongoing = fields.Boolean(dump_to='hasOngoing')
    reasons: fields.Field = fields.List(fields.Integer())


class ModerationsSchema(BaseSchema):
    payments = fields.Nested(ModerationSchema, dump_only=True)
    yandex_pay = fields.Nested(ModerationSchema, dump_only=True)

    @pre_dump
    def dict_keys_to_str(self, data):
        return {k.value: v for k, v in data.items()}


class ModerationRequestSchema(BaseSchema):
    functionality_type = EnumField(FunctionalityType, by_value=True, missing=FunctionalityType.PAYMENTS.value)
