from marshmallow import fields

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.api.schemas.customer_subscription import CustomerSubscription
from mail.payments.payments.api.schemas.order import PayTokenOrderSchema


class OrderCustomerSubscriptionSchema(BaseSchema):
    customer_subscription = fields.Nested(CustomerSubscription)
    order = fields.Nested(PayTokenOrderSchema)


class CustomerSubscriptionResponseSchema(SuccessResponseSchema):
    data = fields.Nested(OrderCustomerSubscriptionSchema)


customer_subscription_response_schema = CustomerSubscriptionResponseSchema()
