from marshmallow import fields, post_load, validate

from mail.payments.payments.api.schemas.base import BaseSchema


class ActiveSchema(BaseSchema):
    operation = fields.String(required=True, load_only=True, validate=validate.OneOf(['activate', 'deactivate']))
    active = fields.Bool()

    @post_load
    def is_active(self, data):
        operation = data.pop('operation')
        data['active'] = operation == 'activate'
        return data


class ShopIDHeaderRequestSchema(BaseSchema):
    """Scheme for loading X-Shop-Id request header"""
    shop_id = fields.Integer(required=False, load_from='x-shop-id')


class UIDRequestSchema(BaseSchema):
    uid = fields.Integer(required=True)


class ShopIDRequestSchema(BaseSchema):
    shop_id = fields.Integer(required=True)


class OrderIDRequestSchema(BaseSchema):
    order_id = fields.Integer(required=True)


class MerchantIdRequestSchema(BaseSchema):
    merchant_id = fields.String(required=True)


class UIDServiceMerchantIDRequestSchema(UIDRequestSchema):
    service_merchant_id = fields.Integer(required=True)


class UIDOrderIDRequestSchema(UIDRequestSchema, OrderIDRequestSchema):
    pass


class UIDShopIDRequestSchema(UIDRequestSchema, ShopIDRequestSchema):
    pass


class UIDOrderIDActiveRequestSchema(UIDOrderIDRequestSchema, ActiveSchema):
    pass


class ServiceMerchantRequestSchema(BaseSchema):
    service_merchant_id = fields.Integer(required=True)


class ServiceMerchantOrderIDRequestSchema(ServiceMerchantRequestSchema):
    order_id = fields.Integer(required=True)


class ServiceMerchantOrderIDActiveRequestSchema(ServiceMerchantOrderIDRequestSchema, ActiveSchema):
    pass


class ServiceMerchantSubscriptionIDRequestSchema(ServiceMerchantRequestSchema):
    subscription_id = fields.Integer(required=True)


class UIDSubscriptionIDRequestSchema(UIDRequestSchema):
    subscription_id = fields.Integer(required=True)


class ServiceMerchantCustomerSubscriptionIDRequestSchema(ServiceMerchantRequestSchema):
    customer_subscription_id = fields.Integer(required=True)


class UIDCustomerSubscriptionIDRequestSchema(UIDRequestSchema):
    customer_subscription_id = fields.Integer(required=True)


class UIDCustomerSubscriptionTransactionRequestSchema(UIDCustomerSubscriptionIDRequestSchema):
    purchase_token = fields.String(required=True)


shop_id_header_request_schema = ShopIDHeaderRequestSchema()

uid_request_schema = UIDRequestSchema()
order_request_schema = OrderIDRequestSchema()
uid_service_merchant_id_schema = UIDServiceMerchantIDRequestSchema()
order_uid_schema = UIDOrderIDRequestSchema()
shop_uid_schema = UIDShopIDRequestSchema()
order_active_uid_schema = UIDOrderIDActiveRequestSchema()
service_merchant_id_request_schema = ServiceMerchantRequestSchema()
order_service_merchant_schema = ServiceMerchantOrderIDRequestSchema()
order_active_service_merchant_schema = ServiceMerchantOrderIDActiveRequestSchema()
subscription_service_merchant_schema = ServiceMerchantSubscriptionIDRequestSchema()
subscription_uid_schema = UIDSubscriptionIDRequestSchema()
customer_subscription_service_merchant_schema = ServiceMerchantCustomerSubscriptionIDRequestSchema()
merchant_id_request_schema = MerchantIdRequestSchema()
customer_subscription_uid_schema = UIDCustomerSubscriptionIDRequestSchema()
customer_subscription_transaction_schema = UIDCustomerSubscriptionTransactionRequestSchema()
