from marshmallow import fields, validate

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.core.entities.enums import PAY_METHODS


class ReportDataSchema(BaseSchema):
    lower_dt = fields.DateTime()
    upper_dt = fields.DateTime()
    pay_method = fields.String()


class ReportSchema(BaseSchema):
    report_id = fields.String()
    created = fields.DateTime()
    mds_path = fields.String()
    uid = fields.Integer()
    data = fields.Nested(ReportDataSchema)


class CreateTaskReportRequestQuerySchema(BaseSchema):
    lower_dt = fields.DateTime(required=True)
    upper_dt = fields.DateTime(required=True)
    pay_method = fields.String(default=None, validate=validate.OneOf(PAY_METHODS))


class ReportResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ReportSchema)


class ReportsListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ReportSchema, many=True)


class DownloadReportRequestSchema(BaseSchema):
    uid = fields.Integer()
    report_id = fields.String()


create_task_report_request_query_schema = CreateTaskReportRequestQuerySchema()
report_response_schema = ReportResponseSchema()
reports_list_response_schema = ReportsListResponseSchema()
download_report_request_schema = DownloadReportRequestSchema()
