from marshmallow import fields
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.payments.payments.core.entities.enums import AcquirerType


class ServiceOptionsSchema(BaseSchema):
    require_online = fields.Boolean()
    required_acquirer = EnumField(AcquirerType, by_value=True, dump_only=True)
    can_skip_registration = fields.Boolean()
    icon_url = fields.String()


class ServiceSchema(BaseSchema):
    service_id = fields.Integer()
    name = fields.String()
    options = fields.Nested(ServiceOptionsSchema)


class ServiceListSchema(BaseSchema):
    services = fields.Nested(ServiceSchema, many=True)


class GetServiceListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(ServiceListSchema)


class GetServiceListRequestSchema(BaseSchema):
    hidden = fields.Constant(False)


get_service_list_response_schema = GetServiceListResponseSchema()
get_service_list_request_schema = GetServiceListRequestSchema()
