from marshmallow import fields
from marshmallow_enum import EnumField

from mail.payments.payments.api.schemas.base import BaseSchema
from mail.payments.payments.core.entities.enums import TransactionStatus


class TransactionSchema(BaseSchema):
    uid = fields.Integer()
    order_id = fields.Integer()
    tx_id = fields.Integer()

    revision = fields.Integer()
    status = EnumField(TransactionStatus, by_value=True)

    created = fields.DateTime()
    updated = fields.DateTime()

    trust_failed_result = fields.String()
    trust_payment_url = fields.String()
    trust_purchase_token = fields.String()
    trust_resp_code = fields.String()
    trust_payment_id = fields.String()
