from aiohttp import web

from sendr_aiohttp.handler import request_schema, response_schema

from mail.payments.payments.api_admin.handlers.base import BaseAdminHandler
from mail.payments.payments.api_admin.schemas.analytics import (
    get_merchant_analytics_request_schema, get_merchant_analytics_response_schema
)
from mail.payments.payments.core.actions.manager.analytics import GetMerchantAnalyticsManagerAction


class AnalyticsHandler(BaseAdminHandler):
    @request_schema(get_merchant_analytics_request_schema, location='query')
    @response_schema(get_merchant_analytics_response_schema)
    async def get(self) -> web.Response:
        analytics_data = await self.run_action(
            GetMerchantAnalyticsManagerAction,
            await self.get_data(),
        )

        response_data = {
            'data': {
                'merchants': analytics_data.merchants,
                'total': analytics_data.stats.total,
                'found': analytics_data.stats.found
            },
        }
        if analytics_data.keyset is not None:
            response_data['data']['next'] = {'keyset': analytics_data.keyset}
        return self.make_response(response_data, get_merchant_analytics_response_schema)
